/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.render.MantleRenderTypes;

public class FluidRenderer {
    public static class_1058 getBlockSprite(class_2960 sprite) {
        return class_310.method_1551().method_1554().method_24153(class_1723.field_21668).method_4608(sprite);
    }

    public static int withBlockLight(int combinedLight, int blockLight) {
        return combinedLight & 0xFFFF0000 | Math.max(blockLight << 4, combinedLight & 0xFFFF);
    }

    private static float boundUV(float value, boolean upper) {
        if ((value %= 1.0f) == 0.0f) {
            return upper ? 1.0f : 0.0f;
        }
        return value < 0.0f ? value + 1.0f : value;
    }

    public static void putTexturedQuad(class_4588 renderer, Matrix4f matrix, class_1058 sprite, Vector3f from, Vector3f to, class_2350 face, int color, int brightness, int rotation, boolean flowing) {
        float u4;
        float v3;
        float u3;
        float maxV;
        float minV;
        float maxU;
        float minU;
        double size;
        float temp;
        float v1;
        float u2;
        float u1;
        float x1 = from.x();
        float y1 = from.y();
        float z1 = from.z();
        float x2 = to.x();
        float y2 = to.y();
        float z2 = to.z();
        float v2 = switch (face) {
            case class_2350.field_11036 -> {
                u1 = x1;
                u2 = x2;
                v1 = -z1;
                yield -z2;
            }
            case class_2350.field_11043 -> {
                u1 = -x1;
                u2 = -x2;
                v1 = y1;
                yield y2;
            }
            case class_2350.field_11035 -> {
                u1 = x2;
                u2 = x1;
                v1 = y1;
                yield y2;
            }
            case class_2350.field_11039 -> {
                u1 = z2;
                u2 = z1;
                v1 = y1;
                yield y2;
            }
            case class_2350.field_11034 -> {
                u1 = -z1;
                u2 = -z2;
                v1 = y1;
                yield y2;
            }
            default -> {
                u1 = x1;
                u2 = x2;
                v1 = z2;
                yield z1;
            }
        };
        if (rotation == 0 || rotation == 270) {
            temp = v1;
            v1 = -v2;
            v2 = -temp;
        }
        if (rotation >= 180) {
            temp = u1;
            u1 = -u2;
            u2 = -temp;
        }
        boolean reverse = u1 > u2;
        u1 = FluidRenderer.boundUV(u1, reverse);
        u2 = FluidRenderer.boundUV(u2, !reverse);
        reverse = v1 > v2;
        v1 = FluidRenderer.boundUV(v1, reverse);
        v2 = FluidRenderer.boundUV(v2, !reverse);
        double d = size = flowing ? 8.0 : 16.0;
        if (rotation % 180 == 90) {
            minU = sprite.method_4580((double)v1 * size);
            maxU = sprite.method_4580((double)v2 * size);
            minV = sprite.method_4570((double)u1 * size);
            maxV = sprite.method_4570((double)u2 * size);
        } else {
            minU = sprite.method_4580((double)u1 * size);
            maxU = sprite.method_4580((double)u2 * size);
            minV = sprite.method_4570((double)v1 * size);
            maxV = sprite.method_4570((double)v2 * size);
        }
        float v4 = switch (rotation) {
            case 90 -> {
                u1 = minU;
                v1 = minV;
                u2 = maxU;
                v2 = minV;
                u3 = maxU;
                v3 = maxV;
                u4 = minU;
                yield maxV;
            }
            case 180 -> {
                u1 = maxU;
                v1 = minV;
                u2 = maxU;
                v2 = maxV;
                u3 = minU;
                v3 = maxV;
                u4 = minU;
                yield minV;
            }
            case 270 -> {
                u1 = maxU;
                v1 = maxV;
                u2 = minU;
                v2 = maxV;
                u3 = minU;
                v3 = minV;
                u4 = maxU;
                yield minV;
            }
            default -> {
                u1 = minU;
                v1 = maxV;
                u2 = minU;
                v2 = minV;
                u3 = maxU;
                v3 = minV;
                u4 = maxU;
                yield maxV;
            }
        };
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (face) {
            case field_11033: {
                renderer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
                break;
            }
            case field_11036: {
                renderer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
                break;
            }
            case field_11043: {
                renderer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
                break;
            }
            case field_11035: {
                renderer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
                break;
            }
            case field_11039: {
                renderer.method_22918(matrix, x1, y1, z2).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y2, z2).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y2, z1).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x1, y1, z1).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
                break;
            }
            case field_11034: {
                renderer.method_22918(matrix, x2, y1, z1).method_1336(r, g, b, a).method_22913(u1, v1).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z1).method_1336(r, g, b, a).method_22913(u2, v2).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y2, z2).method_1336(r, g, b, a).method_22913(u3, v3).method_22921(light1, light2).method_1344();
                renderer.method_22918(matrix, x2, y1, z2).method_1336(r, g, b, a).method_22913(u4, v4).method_22921(light1, light2).method_1344();
            }
        }
    }

    public static void renderCuboid(class_4587 matrices, class_4588 buffer, FluidCuboid cube, class_1058 still, class_1058 flowing, Vector3f from, Vector3f to, int color, int light, boolean isGas) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        int rotation = isGas ? 180 : 0;
        for (class_2350 dir : class_2350.values()) {
            FluidCuboid.FluidFace face = cube.getFace(dir);
            if (face == null) continue;
            boolean isFlowing = face.isFlowing();
            int faceRot = (rotation + face.rotation()) % 360;
            FluidRenderer.putTexturedQuad(buffer, matrix, isFlowing ? flowing : still, from, to, dir, color, light, faceRot, isFlowing);
        }
    }

    public static void renderCuboids(class_4587 matrices, class_4588 buffer, List<FluidCuboid> cubes, FluidStack fluid, int light) {
        if (fluid.isEmpty()) {
            return;
        }
        class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluid.getType());
        class_1058 flowing = FluidVariantRendering.getSprites((FluidVariant)fluid.getType())[1];
        int color = FluidVariantRendering.getColor((FluidVariant)fluid.getType());
        light = FluidRenderer.withBlockLight(light, FluidVariantAttributes.getLuminance((FluidVariant)fluid.getType()));
        boolean isGas = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid.getType());
        for (FluidCuboid cube : cubes) {
            FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        }
    }

    public static void renderCuboid(class_4587 matrices, class_4588 buffer, FluidCuboid cube, float yOffset, class_1058 still, class_1058 flowing, int color, int light, boolean isGas) {
        if (yOffset != 0.0f) {
            matrices.method_22903();
            matrices.method_46416(0.0f, yOffset, 0.0f);
        }
        FluidRenderer.renderCuboid(matrices, buffer, cube, still, flowing, cube.getFromScaled(), cube.getToScaled(), color, light, isGas);
        if (yOffset != 0.0f) {
            matrices.method_22909();
        }
    }

    public static void renderScaledCuboid(class_4587 matrices, class_4597 buffer, FluidCuboid cube, FluidStack fluid, float offset, long capacity, int light, boolean flipGas) {
        if (fluid.isEmpty() || capacity <= 0L) {
            return;
        }
        class_1058 still = FluidVariantRendering.getSprite((FluidVariant)fluid.getType());
        class_1058 flowing = FluidVariantRendering.getSprites((FluidVariant)fluid.getType())[1];
        boolean isGas = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid.getType());
        light = FluidRenderer.withBlockLight(light, FluidVariantAttributes.getLuminance((FluidVariant)fluid.getType()));
        Vector3f from = cube.getFromScaled();
        Vector3f to = cube.getToScaled();
        float minY = from.y();
        float maxY = to.y();
        float height = ((float)fluid.getAmount() - offset) / (float)capacity;
        if (isGas && flipGas) {
            from = new Vector3f((Vector3fc)from);
            from.y = maxY + height * (minY - maxY);
        } else {
            to = new Vector3f((Vector3fc)to);
            to.y = minY + height * (maxY - minY);
        }
        FluidRenderer.renderCuboid(matrices, buffer.getBuffer(MantleRenderTypes.FLUID), cube, still, flowing, from, to, FluidVariantRendering.getColor((FluidVariant)fluid.getType()), light, isGas);
    }
}

